<?php
// public/index.php
declare(strict_types=1);
session_start();

require __DIR__ . '/../config/db.php';
$config = require __DIR__ . '/../config/config.php';

function view(string $path, array $data = []): void {
    extract($data);
    require __DIR__ . '/../app/views/partials/header.php';
    require __DIR__ . '/../app/views/' . $path . '.php';
    require __DIR__ . '/../app/views/partials/footer.php';
}

$path = $_GET['r'] ?? 'dashboard';

$publicRoutes = ['login', 'do_login'];
if (!in_array($path, $publicRoutes, true) && empty($_SESSION['user'])) {
    header('Location: ?r=login');
    exit;
}

function requireRole(array $roles): void {
    if (empty($_SESSION['user']) || !in_array($_SESSION['user']['role'], $roles, true)) {
        http_response_code(403);
        echo "<h1 style='font-family: sans-serif'>403 – Acceso denegado</h1>";
        exit;
    }
}

switch ($path) {
    case 'login':
        require __DIR__ . '/../app/controllers/AuthController.php';
        (new AuthController($pdo, $config))->login();
        break;
    case 'do_login':
        require __DIR__ . '/../app/controllers/AuthController.php';
        (new AuthController($pdo, $config))->doLogin();
        break;
    case 'logout':
        session_destroy();
        header('Location: ?r=login');
        break;
    case 'dashboard':
        view('dashboard', ['title' => 'Panel']);
        break;

    /* === Clientes (nuevo) === */
    case 'clients':
        requireRole(['admin']);
        require __DIR__ . '/../app/controllers/ClientController.php';
        (new ClientController($pdo, $config))->index();
        break;
    case 'clients_create':
        requireRole(['admin']);
        require __DIR__ . '/../app/controllers/ClientController.php';
        (new ClientController($pdo, $config))->create();
        break;
    case 'clients_store':
        requireRole(['admin']);
        require __DIR__ . '/../app/controllers/ClientController.php';
        (new ClientController($pdo, $config))->store();
        break;
    case 'clients_edit':
        requireRole(['admin']);
        require __DIR__ . '/../app/controllers/ClientController.php';
        (new ClientController($pdo, $config))->edit();
        break;
    case 'clients_update':
        requireRole(['admin']);
        require __DIR__ . '/../app/controllers/ClientController.php';
        (new ClientController($pdo, $config))->update();
        break;
    case 'clients_delete':
        requireRole(['admin']);
        require __DIR__ . '/../app/controllers/ClientController.php';
        (new ClientController($pdo, $config))->delete();
        break;
    case 'clients_import':
        requireRole(['admin']);
        require __DIR__ . '/../app/controllers/ClientImportController.php';
        (new ClientImportController($pdo))->form();
        break;

    case 'clients_import_run':
        requireRole(['admin']);
        require __DIR__ . '/../app/controllers/ClientImportController.php';
        (new ClientImportController($pdo))->run();
        break;

    // Products
    case 'products':
        requireRole(['admin']);
        require __DIR__ . '/../app/controllers/ProductController.php';
        (new ProductController($pdo, $config))->index();
        break;
    case 'products_create':
        requireRole(['admin','manager']);
        require __DIR__ . '/../app/controllers/ProductController.php';
        (new ProductController($pdo, $config))->create();
        break;
    case 'products_store':
        requireRole(['admin','manager']);
        require __DIR__ . '/../app/controllers/ProductController.php';
        (new ProductController($pdo, $config))->store();
        break;
    case 'products_edit':
        requireRole(['admin','manager']);
        require __DIR__ . '/../app/controllers/ProductController.php';
        (new ProductController($pdo, $config))->edit();
        break;
    case 'products_update':
        requireRole(['admin','manager']);
        require __DIR__ . '/../app/controllers/ProductController.php';
        (new ProductController($pdo, $config))->update();
        break;
    case 'products_delete':
        requireRole(['admin']);
        require __DIR__ . '/../app/controllers/ProductController.php';
        (new ProductController($pdo, $config))->delete();
        break;

    // Quotes
    case 'quotes':
        requireRole(['admin', 'tech']);
        require __DIR__ . '/../app/controllers/QuoteController.php';
        (new QuoteController($pdo, $config))->index();
        break;
    case 'quotes_create':
        requireRole(['admin', 'tech']);
        require __DIR__ . '/../app/controllers/QuoteController.php';
        (new QuoteController($pdo, $config))->create();
        break;
    case 'quotes_store':
        requireRole(['admin', 'tech']);
        require __DIR__ . '/../app/controllers/QuoteController.php';
        (new QuoteController($pdo, $config))->store();
        break;
    case 'quotes_view':
        requireRole(['admin', 'tech']);
        require __DIR__ . '/../app/controllers/QuoteController.php';
        (new QuoteController($pdo, $config))->view();
        break;
    case 'quotes_print':
        requireRole(['admin', 'tech']);
        require __DIR__ . '/../app/controllers/QuoteController.php';
        (new QuoteController($pdo, $config))->printView();
        break;
    case 'quotes_edit':
        requireRole(['admin']);
        require __DIR__ . '/../app/controllers/QuoteController.php';
        (new QuoteController($pdo, $config))->edit();
        break;
    case 'quotes_update':
        requireRole(['admin']);
        require __DIR__ . '/../app/controllers/QuoteController.php';
        (new QuoteController($pdo, $config))->update();
    break;

    // Users (admin only)
    case 'users':
        requireRole(['admin']);
        require __DIR__ . '/../app/controllers/UserController.php';
        (new UserController($pdo, $config))->index();
        break;
    case 'users_create':
        requireRole(['admin']);
        require __DIR__ . '/../app/controllers/UserController.php';
        (new UserController($pdo, $config))->create();
        break;
    case 'users_store':
        requireRole(['admin']);
        require __DIR__ . '/../app/controllers/UserController.php';
        (new UserController($pdo, $config))->store();
        break;
    default:
        http_response_code(404);
        echo "<h1 style='font-family: sans-serif'>404 – Página no encontrada</h1>";
        break;
}
