<?php
// app/views/users/index.php
?>
<div class="d-flex justify-content-between align-items-center mb-3">
  <h4>Usuarios</h4>
  <a class="btn btn-primary" href="?r=users_create">Nuevo usuario</a>
</div>
<div class="card p-2">
  <div class="table-responsive">
  <table class="table table-striped align-middle">
    <thead><tr><th>ID</th><th>Nombre</th><th>Email</th><th>Rol</th><th>Creado</th></tr></thead>
    <tbody>
    <?php foreach($users as $u): ?>
      <tr>
        <td><?= (int)$u['id'] ?></td>
        <td><?= htmlspecialchars($u['name']) ?></td>
        <td><?= htmlspecialchars($u['email']) ?></td>
        <td><span class="badge text-bg-secondary"><?= htmlspecialchars($u['role']) ?></span></td>
        <td><?= htmlspecialchars($u['created_at']) ?></td>
      </tr>
    <?php endforeach; ?>
    </tbody>
  </table>
  </div>
</div>
