<?php
// app/views/quotes/view.php (muestra instalación e insumos)
?>
<div class="d-flex justify-content-between align-items-center mb-3">
  <h4>Cotización #<?= (int)$quote['id'] ?></h4>
  <div>
    <a class="btn btn-warning" href="?r=quotes_edit&id=<?= (int)$quote['id'] ?>">Editar</a>
    <a class="btn btn-primary" href="?r=quotes_print&id=<?= (int)$quote['id'] ?>" target="_blank">PDF</a>
  </div>
</div>

<div class="card p-3 mb-3">
  <div class="row">
    <div class="col-md-6">
      <h6 class="text-secondary">Cliente</h6>
      <div>
        <?php if(!empty($quote['client_name'])): ?>
          <div><strong><?= htmlspecialchars($quote['client_name']) ?></strong><?= $quote['company'] ? ' — '.htmlspecialchars($quote['company']) : '' ?></div>
          <div class="small text-secondary"><?= htmlspecialchars($quote['email'] ?: '') ?> <?= htmlspecialchars($quote['phone'] ? ' · '.$quote['phone'] : '') ?></div>
          <div class="small text-secondary"><?= htmlspecialchars($quote['address'] ?: '') ?></div>
        <?php else: ?>
          <?= htmlspecialchars($quote['customer']) ?>
        <?php endif; ?>
      </div>
    </div>
    <div class="col-md-6">
      <h6 class="text-secondary">Generada por</h6>
      <div><?= htmlspecialchars($quote['user_name']) ?> · <?= htmlspecialchars($quote['created_at']) ?></div>
    </div>
  </div>
</div>

<div class="card p-2 mb-3">
  <div class="table-responsive">
  <table class="table table-striped align-middle">
    <thead><tr><th>SKU</th><th>Producto</th><th class="text-end">Cantidad</th><th class="text-end">Precio</th><th class="text-end">Importe</th></tr></thead>
    <tbody>
    <?php $subtotal = 0.0; foreach($items as $it): $imp = (float)$it['price'] * (int)$it['qty']; $subtotal += $imp; ?>
      <tr>
        <td><code><?= htmlspecialchars($it['sku']) ?></code></td>
        <td><?= htmlspecialchars($it['name']) ?></td>
        <td class="text-end"><?= (int)$it['qty'] ?></td>
        <td class="text-end">$<?= number_format((float)$it['price'], 2) ?></td>
        <td class="text-end">$<?= number_format($imp, 2) ?></td>
      </tr>
    <?php endforeach; ?>
    </tbody>
  </table>
  </div>
</div>

<?php
$instCost = (float)($quote['installation_cost'] ?? 0);
$suppCost = (float)($quote['supplies_cost'] ?? 0);
?>

<?php if(!empty($quote['supplies_desc']) || $suppCost > 0): ?>
<div class="card p-3 mb-3">
  <h6 class="text-secondary mb-2">Insumos / Consumibles</h6>
  <?php if(!empty($quote['supplies_desc'])): ?>
    <div class="mb-1"><?= nl2br(htmlspecialchars($quote['supplies_desc'])) ?></div>
  <?php endif; ?>
  <div><strong>Costo:</strong> $<?= number_format($suppCost, 2) ?></div>
</div>
<?php endif; ?>

<?php if(!empty($quote['installation_desc']) || $instCost > 0): ?>
<div class="card p-3 mb-3">
  <h6 class="text-secondary mb-2">Instalación</h6>
  <?php if(!empty($quote['installation_desc'])): ?>
    <div class="mb-1"><?= nl2br(htmlspecialchars($quote['installation_desc'])) ?></div>
  <?php endif; ?>
  <div><strong>Costo:</strong> $<?= number_format($instCost, 2) ?></div>
</div>
<?php endif; ?>

<div class="card p-3">
  <div class="d-flex justify-content-end">
    <div style="min-width: 280px">
      <div class="d-flex justify-content-between"><span>Subtotal productos</span><span>$<?= number_format($subtotal, 2) ?></span></div>      
      <?php if($suppCost>0): ?><div class="d-flex justify-content-between"><span>Insumos</span><span>$<?= number_format($suppCost, 2) ?></span></div><?php endif; ?>
      <?php if($instCost>0): ?><div class="d-flex justify-content-between"><span>Instalación</span><span>$<?= number_format($instCost, 2) ?></span></div><?php endif; ?>
      <hr>
      <div class="d-flex justify-content-between h5"><strong>Total</strong><strong>$<?= number_format((float)$quote['total'], 2) ?></strong></div>
    </div>
  </div>
</div>