<?php
// app/views/quotes/create.php (con campos de instalación e insumos)
?>
<h4>Nueva cotización</h4>
<div class="card p-3">
  <form action="?r=quotes_store" method="post">
    <div class="row g-3">
      <div class="col-md-6">
        <label class="form-label">Cliente</label>
        <select class="form-select" name="client_id" id="client_id">
          <option value="">-- Selecciona cliente --</option>
          <?php foreach($clients as $c): ?>
            <option value="<?= (int)$c['id'] ?>"><?= htmlspecialchars($c['name']) ?><?= $c['company'] ? ' — '.htmlspecialchars($c['company']) : '' ?></option>
          <?php endforeach; ?>
        </select>
        <div class="form-text">o escribe un nombre libre:</div>
        <input class="form-control mt-1" name="customer" placeholder="Nombre del cliente (opcional si seleccionas uno)">
      </div>
      <div class="col-md-6">
        <label class="form-label">Notas</label>
        <input class="form-control" name="notes" placeholder="Validez, tiempos de entrega, etc.">
      </div>
    </div>

    <hr class="my-3">
    <div class="d-flex justify-content-between align-items-center">
      <h6>Ítems</h6>
      <button type="button" class="btn btn-sm btn-outline-secondary no-print" data-add-item>Agregar ítem</button>
    </div>

    <div id="items" class="mt-2">
      <div class="row g-2 item-row align-items-end">
        <div class="col-md-6">
          <label class="form-label">Producto</label>
          <select class="form-select" name="items[product_id][]" required>
            <option value="">-- Selecciona --</option>
            <?php foreach($products as $p): ?>
              <option value="<?= (int)$p['id'] ?>">
                <?= htmlspecialchars($p['name']) ?> (<?= htmlspecialchars($p['sku']) ?>) — $<?= number_format((float)$p['price'], 2) ?> | Stock: <?= (int)$p['stock'] ?>
              </option>
            <?php endforeach; ?>
          </select>
        </div>
        <div class="col-md-2">
          <label class="form-label">Cantidad</label>
          <input type="number" class="form-control" name="items[qty][]" value="1" min="1" step="1">
        </div>
        <div class="col-md-2">
          <button type="button" class="btn btn-outline-danger w-100" data-remove-item>Quitar</button>
        </div>
      </div>
    </div>

    <template id="item-template">
      <div class="row g-2 item-row align-items-end">
        <div class="col-md-6">
          <label class="form-label">Producto</label>
          <select class="form-select" name="items[product_id][]" required>
            <option value="">-- Selecciona --</option>
            <?php foreach($products as $p): ?>
              <option value="<?= (int)$p['id'] ?>">
                <?= htmlspecialchars($p['name']) ?> (<?= htmlspecialchars($p['sku']) ?>) — $<?= number_format((float)$p['price'], 2) ?> | Stock: <?= (int)$p['stock'] ?>
              </option>
            <?php endforeach; ?>
          </select>
        </div>
        <div class="col-md-2">
          <label class="form-label">Cantidad</label>
          <input type="number" class="form-control" name="items[qty][]" value="1" min="1" step="1">
        </div>
        <div class="col-md-2">
          <button type="button" class="btn btn-outline-danger w-100" data-remove-item>Quitar</button>
        </div>
      </div>
    </template>

    <hr class="my-4">
    <div class="row g-3">      
      <div class="col-md-8">
        <label class="form-label">Insumos / Consumibles</label>
        <textarea class="form-control" name="supplies_desc" rows="3" placeholder="Detalle de insumos y consumibles"></textarea>
      </div>
      <div class="col-md-4">
        <label class="form-label">Costo de insumos (MXN)</label>
        <input type="number" class="form-control" name="supplies_cost" step="0.01" min="0" value="0">
      </div>
      <div class="col-md-8">
        <label class="form-label">Descripción de instalación</label>
        <textarea class="form-control" name="installation_desc" rows="3" placeholder="Descripción del servicio de instalación"></textarea>
      </div>
      <div class="col-md-4">
        <label class="form-label">Costo de instalación (MXN)</label>
        <input type="number" class="form-control" name="installation_cost" step="0.01" min="0" value="0">
      </div>
    </div>

    <div class="mt-3">
      <button class="btn btn-primary">Guardar cotización</button>
      <a class="btn btn-outline-secondary" href="?r=quotes">Cancelar</a>
    </div>
  </form>
</div>

<script>
(function(){
  function onClick(e){
    var add = e.target.closest('[data-add-item]');
    var rm  = e.target.closest('[data-remove-item]');
    if (add){
      e.preventDefault(); e.stopPropagation();
      var tpl = document.getElementById('item-template');
      var container = document.getElementById('items');
      if (tpl && container){
        container.appendChild(tpl.content.cloneNode(true));
      }
      return;
    }
    if (rm){
      e.preventDefault(); e.stopPropagation();
      var row = rm.closest('.item-row');
      if (row){ row.remove(); }
      return;
    }
  }
  document.addEventListener('DOMContentLoaded', function(){
    document.addEventListener('click', onClick, false);
  });
})();
</script>