<?php
// app/views/products/index.php
?>
<div class="d-flex justify-content-between align-items-center mb-3">
  <h4>Productos</h4>
  <?php if(in_array($_SESSION['user']['role'], ['admin','manager'], true)): ?>
    <a class="btn btn-primary" href="?r=products_create">Nuevo</a>
  <?php endif; ?>
</div>
<form class="row g-2 mb-3">
  <input type="hidden" name="r" value="products">
  <div class="col-md-6">
    <input class="form-control" name="q" placeholder="Buscar por nombre o SKU" value="<?= htmlspecialchars($_GET['q'] ?? '') ?>">
  </div>
  <div class="col-md-2">
    <button class="btn btn-outline-light w-100">Buscar</button>
  </div>
</form>
<div class="card p-2">
  <div class="table-responsive">
  <table class="table table-striped align-middle">
    <thead><tr><th>ID</th><th>SKU</th><th>Nombre</th><th>Categoría</th><th class="text-end">Precio</th><th class="text-end">Stock</th><th class="text-end">Acciones</th></tr></thead>
    <tbody>
    <?php foreach($products as $p): ?>
      <tr>
        <td><?= (int)$p['id'] ?></td>
        <td><code><?= htmlspecialchars($p['sku']) ?></code></td>
        <td><?= htmlspecialchars($p['name']) ?></td>
        <td><?= htmlspecialchars($p['category']) ?></td>
        <td class="text-end">$<?= number_format((float)$p['price'], 2) ?></td>
        <td class="text-end"><?= (int)$p['stock'] ?></td>
        <td class="text-end">
          <?php if(in_array($_SESSION['user']['role'], ['admin','manager'], true)): ?>
          <a class="btn btn-sm btn-outline-light" href="?r=products_edit&id=<?= (int)$p['id'] ?>">Editar</a>
          <a class="btn btn-sm btn-outline-danger" href="?r=products_delete&id=<?= (int)$p['id'] ?>" onclick="return confirm('¿Eliminar producto?')">Eliminar</a>
          <?php endif; ?>
        </td>
      </tr>
    <?php endforeach; ?>
    </tbody>
  </table>
  </div>
</div>
