<?php
// app/views/partials/header.php
$config = $config ?? (require __DIR__ . '/../../../config/config.php');
$appName = $config['app_name'];
$company = $config['company'];
?><!doctype html>
<html lang="es">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?= htmlspecialchars($title ?? $appName) ?> — <?= htmlspecialchars($appName) ?></title>
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css">
  <link rel="stylesheet" href="/assets/css/app.css">
</head>
<body>
<nav class="navbar navbar-expand-lg navbar-dark bg-dark mb-4">
  <div class="container-fluid">
    <a class="navbar-brand d-flex align-items-center" href="?r=dashboard">
      <img src="<?= htmlspecialchars($company['logo']) ?>" alt="SCALIA" height="28" class="me-2">      
    </a>
    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#nav">
      <span class="navbar-toggler-icon"></span>
    </button>
    <div id="nav" class="collapse navbar-collapse">
      <?php if(!empty($_SESSION['user'])): ?>
      <ul class="navbar-nav me-auto">
        <li class="nav-item"><a class="nav-link" href="?r=clients">Clientes</a></li>
        <li class="nav-item"><a class="nav-link" href="?r=products">Productos</a></li>
        <li class="nav-item"><a class="nav-link" href="?r=quotes">Cotizaciones</a></li>
        <?php if($_SESSION['user']['role']==='admin'): ?>
        <li class="nav-item"><a class="nav-link" href="?r=users">Usuarios</a></li>
        <?php endif; ?>
      </ul>
      <div class="d-flex align-items-center text-light small">
        <span class="me-3"><?= htmlspecialchars($_SESSION['user']['name'] ?? '') ?> (<?= htmlspecialchars($_SESSION['user']['role'] ?? '') ?>)</span>
        <a class="btn btn-outline-light btn-sm" href="?r=logout">Salir</a>
      </div>
      <?php endif; ?>
    </div>
  </div>
</nav>
<div class="container">
