<?php /* app/views/clients/view.php */ ?>
<h4><?= htmlspecialchars($client['name']) ?> <?= $client['company'] ? '— '.htmlspecialchars($client['company']) : '' ?></h4>

<div class="card p-3">
  <div class="row">
    <div class="col-md-6">
      <div><strong>Email principal:</strong> <?= htmlspecialchars($client['email'] ?: '—') ?></div>
      <div><strong>Teléfono:</strong> <?= htmlspecialchars($client['phone'] ?: '—') ?></div>
    </div>
    <div class="col-md-6">
      <div><strong>Dirección:</strong> <?= htmlspecialchars($client['address'] ?: '—') ?></div>
      <div><strong>Provincia / Estado:</strong> <?= htmlspecialchars($client['province_state'] ?: '—') ?></div>
      <div><strong>Código Postal:</strong> <?= htmlspecialchars($client['postal_code'] ?: '—') ?></div>
    </div>
  </div>

  <?php if (!empty($emails)): ?>
    <hr>
    <div><strong>Todos los emails:</strong></div>
    <ul class="mb-0">
      <?php foreach($emails as $em): ?>
        <li><?= htmlspecialchars($em['email']) ?></li>
      <?php endforeach; ?>
    </ul>
  <?php endif; ?>
</div>
