<?php
// app/views/clients/index.php
?>
<div class="d-flex justify-content-between align-items-center mb-3">
  <h4>Clientes</h4>
  <a class="btn btn-outline-primary" href="?r=clients_import">Importar</a>
  <a class="btn btn-primary" href="?r=clients_create">Nuevo</a>
</div>
<form class="row g-2 mb-3">
  <input type="hidden" name="r" value="clients">
  <div class="col-md-6">
    <input class="form-control" name="q" placeholder="Buscar por nombre, empresa o email" value="<?= htmlspecialchars($_GET['q'] ?? '') ?>">
  </div>
  <div class="col-md-2">
    <button class="btn btn-outline-primary w-100">Buscar</button>
  </div>
</form>
<div class="card p-2">
  <div class="table-responsive">
  <table class="table table-striped align-middle">
    <thead><tr><th>ID</th><th>Nombre</th><th>Empresa</th><th>Email</th><th>Teléfono</th><th>Dirección</th><th class="text-end">Acciones</th></tr></thead>
    <tbody>
    <?php foreach($clients as $c): ?>
      <tr>
        <td><?= (int)$c['id'] ?></td>
        <td><?= htmlspecialchars($c['name']) ?></td>
        <td><?= htmlspecialchars($c['company']) ?></td>
        <td><?= htmlspecialchars($c['email']) ?></td>
        <td><?= htmlspecialchars($c['phone']) ?></td>
        <td><?= htmlspecialchars($c['address']) ?></td>
        <td class="text-end">
          <a class="btn btn-sm btn-outline-secondary" href="?r=clients_edit&id=<?= (int)$c['id'] ?>">Editar</a>
          <a class="btn btn-sm btn-outline-danger" href="?r=clients_delete&id=<?= (int)$c['id'] ?>" onclick="return confirm('¿Eliminar cliente?')">Eliminar</a>
        </td>
      </tr>
    <?php endforeach; ?>
    </tbody>
  </table>
  </div>
</div>
