<?php /* app/views/clients/import.php */ ?>
<div class="d-flex justify-content-between align-items-center mb-3">
  <h4>Importar clientes</h4>
  <a class="btn btn-outline-secondary" href="?r=clients">Volver</a>
</div>

<?php if(!empty($_SESSION['error'])): ?>
  <div class="alert alert-danger"><?= htmlspecialchars($_SESSION['error']); unset($_SESSION['error']); ?></div>
<?php endif; ?>
<?php if(!empty($_SESSION['success'])): ?>
  <div class="alert alert-success"><?= htmlspecialchars($_SESSION['success']); unset($_SESSION['success']); ?></div>
<?php endif; ?>

<div class="card p-3">
  <form action="?r=clients_import_run" method="post" enctype="multipart/form-data">
    <div class="mb-3">
      <label class="form-label">Archivo</label>
      <input type="file" name="file" class="form-control" accept=".csv,.xlsx,.xls" required>
      <div class="form-text">
        Sube un <strong>CSV (UTF-8)</strong> exportado desde tu Excel, o <strong>XLS/XLSX</strong> si tu servidor tiene PhpSpreadsheet.
      </div>
    </div>

    <div class="mb-2">
      <strong>Encabezados que se reconocen automáticamente:</strong><br>
      <code>Nombre</code>, <code>Empresa</code>, <code>Email</code> (varios separados por coma/;),
      <code>Teléfono</code>, <code>Calle/Dirección</code>, <code>Provincia / Estado</code>, <code>Código Postal</code>.
    </div>

    <button class="btn btn-primary">Importar</button>
  </form>
</div>
