<?php /* app/views/clients/edit.php */ ?>
<h4>Editar cliente</h4>
<div class="card p-3">
  <form action="?r=clients_update" method="post" class="row g-3">
    <input type="hidden" name="id" value="<?= (int)$client['id'] ?>">
    <div class="col-md-6">
      <label class="form-label">Nombre</label>
      <input class="form-control" name="name" value="<?= htmlspecialchars($client['name']) ?>" required>
    </div>
    <div class="col-md-6">
      <label class="form-label">Empresa</label>
      <input class="form-control" name="company" value="<?= htmlspecialchars($client['company']) ?>">
    </div>
    <div class="col-md-6">
      <label class="form-label">Email(s)</label>
      <input class="form-control" name="email" value="<?= htmlspecialchars($client['email']) ?>" placeholder="Varios separados por coma o ;">
      <div class="form-text">El primero se usa como principal; todos se guardan.</div>
    </div>
    <div class="col-md-6">
      <label class="form-label">Teléfono</label>
      <input class="form-control" name="phone" value="<?= htmlspecialchars($client['phone']) ?>">
    </div>
    <div class="col-md-8">
      <label class="form-label">Dirección</label>
      <input class="form-control" name="address" value="<?= htmlspecialchars($client['address']) ?>">
    </div>
    <div class="col-md-4">
      <label class="form-label">Provincia / Estado</label>
      <input class="form-control" name="province_state" value="<?= htmlspecialchars($client['province_state'] ?? '') ?>">
    </div>
    <div class="col-md-4">
      <label class="form-label">Código Postal</label>
      <input class="form-control" name="postal_code" value="<?= htmlspecialchars($client['postal_code'] ?? '') ?>">
    </div>
    <div class="col-12">
      <button class="btn btn-primary">Actualizar</button>
      <a class="btn btn-outline-secondary" href="?r=clients">Cancelar</a>
    </div>
  </form>
</div>
