<?php
// app/controllers/AuthController.php
declare(strict_types=1);

class AuthController {
    public function __construct(private PDO $db, private array $config) {}

    public function login(): void {
        if (!empty($_SESSION['user'])) {
            header('Location: ?r=dashboard'); exit;
        }
        $title = 'Iniciar sesión';
        require __DIR__ . '/../views/partials/header.php';
        require __DIR__ . '/../views/login.php';
        require __DIR__ . '/../views/partials/footer.php';
    }

    public function doLogin(): void {
        $email = $_POST['email'] ?? '';
        $pass = $_POST['password'] ?? '';

        $stmt = $this->db->prepare("SELECT id, name, email, role, password_hash FROM users WHERE email = ? LIMIT 1");
        $stmt->execute([$email]);
        $user = $stmt->fetch();
        if ($user && password_verify($pass, $user['password_hash'])) {
            $_SESSION['user'] = [
                'id' => (int)$user['id'],
                'name' => $user['name'],
                'email' => $user['email'],
                'role' => $user['role']
            ];
            header('Location: ?r=dashboard'); exit;
        }
        $_SESSION['error'] = 'Credenciales inválidas.';
        header('Location: ?r=login'); exit;
    }
}
